# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 5
# Experiment: PMxPM, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A_MR5_strategy.txt
# LLM Suggested Fallback: C

def serendipitous_phoenix(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:
        return "C"
    
    current_round = len(my_history)
    total_rounds = 10
    opp_defections = opp_history.count("D")
    
    # Detect simple opponent strategies
    is_always_c = "return \"C\"" in opponent_program_code or "always_cooperate" in opponent_program_code.lower()
    is_always_d = "return \"D\"" in opponent_program_code or "always_defect" in opponent_program_code.lower()
    
    if is_always_c:
        return "D"
    if is_always_d:
        return "C" if random.random() < 0.9 else "D"
    
    # Tit-for-tat with forgiveness
    last_opp_move = opp_history[-1]
    if last_opp_move == "C":
        my_move = "C"
    else:
        my_move = "D" if random.random() > 0.1 else "C"
    
    # Late-game adjustment
    if current_round >= total_rounds - 2 and opp_defections > 2:
        my_move = "D"
    
    # Add small random noise
    if random.random() < 0.05:
        my_move = "D" if my_move == "C" else "C"
    
    return my_move